<?php
require_once 'config.php';

if (!isset($_GET['id'])) {
    http_response_code(400);
    echo json_encode(['error' => 'Category ID not provided']);
    exit;
}

$category_id = intval($_GET['id']);

$conn = getSecureConnection();

$stmt = $conn->prepare("SELECT * FROM categories WHERE id = ?");
$stmt->bind_param("i", $category_id);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows === 0) {
    http_response_code(404);
    echo json_encode(['error' => 'Category not found']);
    exit;
}

$category = $result->fetch_assoc();
$stmt->close();
$conn->close();

echo json_encode($category);
?>
